#include "mbed.h"
#include "ConfigFile.h"
#include "SDHCFileSystem.h"
#include "EthernetNetIf.h"
#include "NTPClient.h"
#include "HTTPClient.h"
#include "weather.h"

/** @file
 * @brief mbed Weather Platform
 */

#define TIMEZONE 9
//#define NONBLOCKING

#define STATION_URL "http://weather.sugakoubou.com/p"
#define TWITTER_URL "http://api.supertweet.net/1/statuses/update.xml"


void writefile (char *buf) {
    FILE *fp;

    fp = fopen(filename, "a");
    if (fp) {
        fprintf(fp, buf);
        fclose(fp);
    } else {
        led2 = 0;
        conf.filetype = 0;
    }
}

void weatherstations () {
    char post_data[200];
    HTTPResult ret;
    HTTPText postContent("application/x-www-form-urlencoded");

    led_y = 0;
    strcpy(post_data, "fcd=");
    strcat(post_data, conf.stations_id);
    strcat(post_data, "&pin=");
    strcat(post_data, conf.stations_pin);
    sprintf(&post_data[strlen(post_data)], "&d0=%.2f&d1=%.2f&d2=%.2f&d3=%.2f&d4=%.2f&d5=%.2f&d6=%.2f&d7=%.2f&d8=%.2f&d9=%.2f",
      sensor.pres, sensor.temp, sensor.humi, sensor.anemo, sensor.vane, sensor.rain, sensor.light, sensor.uv, sensor.moist, sensor.temp2);
    postContent.puts(post_data);

#ifdef NONBLOCKING
    Net::poll();
    ret = clientP->post(STATION_URL, postContent, NULL, &cb_clientP);
    Net::poll();
#else
    ret = clientP->post(STATION_URL, postContent, NULL);
#endif

    if (ret != HTTP_OK && ret != HTTP_PROCESSING) {
        pc.printf("error: Weather Statuons %d\r\n", ret);
    }
}

void pachube (char *buf) {
    char uri[100];
    HTTPResult ret;
    HTTPText csvContent("text/csv");

    led_y = 0;
    clientP->setRequestHeader("X-PachubeApiKey", conf.pachube_apikey);
    csvContent.set(buf);
    strcpy(uri, "http://api.pachube.com/v1/feeds/");
    strcat(uri, conf.pachube_feedid);
    strcat(uri, ".csv?_method=put");
#ifdef NONBLOCKING
    Net::poll();
    ret = clientP->post(uri, csvContent, NULL, &cb_clientP);
    Net::poll();
#else
    ret = clientP->post(uri, csvContent, NULL);
#endif

    if (ret != HTTP_OK && ret != HTTP_PROCESSING) {
        pc.printf("error: Pachube %d\r\n", ret);
    }
}

void cb_clientP (HTTPResult status) {
    if (status != HTTP_OK) {
        pc.printf("Pachube failure (%d)\r\n", status);
//        pc.printf("Pachube failure (%d, %d)\r\n", status, clientP->getHTTPResponseCode());
    }
}

char *fmtstr (char *fmt, char *buf, int len) {
    int i, j, flg;
    char c;
    float value;
    time_t sec = time(NULL);
    struct tm *tim = localtime(&sec);

    j = 0;
    for (i = 0; i < strlen(fmt) && j < len; i ++) {
        c = fmt[i];
        if (c == '%') {
            flg = 0;
            i ++;
            c = fmt[i];
            
            if (c == '.') {
                // float format
                if (fmt[i + 1] >= '0' && fmt[i + 1] <= '9') {
                    flg = fmt[i + 1] - '0';
                    i ++;

                    c = fmt[i + 1];
                    i ++;
                }
            }

            switch (c) {
            case 'P':
                value = sensor.pres;
                break;
            case 'T':
                value = sensor.temp;
                break;
            case 'H':
                value = sensor.humi;
                break;
            case 'A':
                value = sensor.anemo;
                break;
            case 'V':
                value = sensor.vane;
                break;
            case 'R':
                value = sensor.rain;
                break;
            case 'L':
                value = sensor.light;
                break;
            case 'U':
                value = sensor.uv;
                break;
            case 'M':
                value = sensor.moist;
                break;

            case 'y':
                value = tim->tm_year + 1900;
                break;
            case 'm':
                value = tim->tm_mon;
                break;
            case 'd':
                value = tim->tm_mday;
                break;
            case 'h':
                value = tim->tm_hour;
                break;
            case 'i':
                value = tim->tm_min;
                break;
            case 's':
                value = tim->tm_sec;
                break;

            case '0':
            case '1':
            case '2':
            case '3':
            case '4':
            case '5':
            case '6':
            case '7':
            case '8':
            case '9':
                // Ascii
                c = c - '0';
                if (fmt[i + 1] >= '0' && fmt[i + 1] <= '9') {
                    c = (c << 3) | (fmt[i + 1] - '0');
                    i ++;
                    if (fmt[i + 1] >= '0' && fmt[i + 1] <= '9') {
                        c = (c << 3) | (fmt[i + 1] - '0');
                        i ++;
                    }
                }
                buf[j] = c;
                j ++;
                continue;

            default:
                buf[j] = c;
                j ++;
                continue;
            }

            switch (flg) {
            case 1:
                sprintf(&buf[j], "%.1f", value);
                break;
            case 2:
                sprintf(&buf[j], "%.2f", value);
                break;
            default:
                sprintf(&buf[j], "%02d", (int)value);
                break;
            }
            j = strlen(buf);
        } else {
            buf[j] = c;
            j ++;
        }
    }
    buf[j] = 0;
    return buf;
}

void twitter (int num) {
    HTTPMap msg;
    HTTPResult ret;
    char buf[170];

    led_y = 0;
    fmtstr(conf.twitter_mesg[num], buf, sizeof(buf));
    msg["status"] = buf;

    clientT->basicAuth(conf.twitter_user, conf.twitter_pwd);
#ifdef NONBLOCKING
    Net::poll();
    ret = clientT->post(TWITTER_URL, msg, NULL, &cb_clientT); 
    Net::poll();
#else
    ret = clientT->post(TWITTER_URL, msg, NULL); 
#endif

    if (ret != HTTP_OK && ret != HTTP_PROCESSING) {
        pc.printf("error: Twitter %d\r\n", ret);
    }
}

void ntpdate () {
    ntp = new NTPClient;
    Host ntpserver(IpAddr(), 123, conf.ntpserver);

    led_y = 0;
#ifdef NONBLOCKING
    Net::poll();
    ntp->setTime(ntpserver, &cb_settime);
    Net::poll();
#else
    ntp->setTime(ntpserver);
    time_t sec = time(NULL) + (60 * 60 * TIMEZONE);
    set_time(sec);
#endif
}

void cb_settime (NTPResult status) {
    if (status == NTP_OK) {
        led_y = 0;
        time_t sec = time(NULL) + (60 * 60 * TIMEZONE);
        set_time(sec);
        pc.printf("Ntp success: %s\r\n", ctime(&sec));
    } else {
        pc.printf("Ntp failure (%d)\r\n", status);
    }
//    ntp->close();
}
