#include "mbed.h"
#include "BMP085.h"
#include "SHT.h"
#include "WeatherMeters.h"

I2C i2c(p9, p10);

BMP085 bmp085(i2c, BMP085_oss4);
SHT sht11(p24, p12, SHT_high); // sclock, data
WeatherMeters wmeters(p30, p17, p21); // anemo, vane, rain

DigitalOut myled(LED1);
Serial pc(USBTX, USBRX);
AnalogIn photo(p18);
AnalogIn moist(p16);
AnalogIn uv(p15);

float get_photo (AnalogIn &ain) {
    float f;
    
    f = ain * 5.0 / 1000; // A
    return f / 0.0000026; // lx
}

float get_moist (AnalogIn &ain) {
    float f;
    
    f = ain * 5.0; // V
    return f / ((3.3 - f) / 10.0); // k ohm
}

float get_uv (AnalogIn &ain) {
    float f;
    
    f = ain * 5.0 / 100000; // A
    return f / 0.000384; // mW/cm2
}

int main() {
    while(1) {
        myled = 1;

        bmp085.update();
        pc.printf("p:%6.2f hPa / t:%6.2f C\n", bmp085.get_pressure(), bmp085.get_temperature());

        sht11.update(SHT_high);
        pc.printf("t:%6.2f C / h:%6.2f %%\n", sht11.get_temperature(), sht11.get_humidity());

        pc.printf("a:%6.2f m/s / v:%6.2f / r:%6.2f mm\n", wmeters.get_windspeed(), wmeters.get_windvane(), wmeters.get_raingauge());

        pc.printf("l:%6.2f lx\n", get_photo(photo));
        pc.printf("l:%6.2f k ohm\n", get_moist(moist));
        pc.printf("l:%6.2f mW/cm2\n", get_uv(uv));

        myled = 0;
        wait(10);
    }
}
