#include "mbed.h"
#include <math.h>

Ticker ticker;
volatile long val;
volatile int offset, count;

DigitalOut myled(LED1);
AnalogIn adc_offset(p15), adc_watt1(p16), adc_watt3(p18);
Serial pc(USBTX, USBRX); 

void sample_watt () {
    int i;

    i = ((adc_watt3.read_u16() >> 4) & 0x0fff) - offset;
    if (i < -1 || i > 1) {
        val = val + (i * i);
    }
    count ++;
}

int main() {
    float v, f, g;

    offset = (adc_offset.read_u16() >> 4) & 0x0fff;
    val = 0;
    count = 0;

    ticker.attach_us(&sample_watt, 100); // 10kHz
    pc.printf("begin\r\n");

    while(1) {
        if (count >= 10000) {
            myled = 1;
            // RMS
            __disable_irq();
            v = sqrt((float)val / count) * (3.3 / 0x1000);
            f = v / (0.99 * 330.0 / 3000.0);
            val = 0;
            count = 0;

            g = ((adc_watt1.read_u16() >> 4) & 0x0fff) - offset;
            g = g * (3.3 / 0x1000);
            g = g / (0.99 * 330.0 / 3000.0); 

            offset = (adc_offset.read_u16() >> 4) & 0x0fff;
            __enable_irq();

            pc.printf("%.2f A ave , ", g);
            pc.printf("%.2f A rms\r\n", f);

            myled = 0;
        }
    }
}
