#ifndef _WDT_H_
#define _WDT_H_

#include "mbed.h"

// Simon's Watchdog
// see: http://mbed.org/forum/mbed/topic/508/
class Watchdog {
public:
// Load timeout value in watchdog timer and enable
    void init(float s);
// "kick" or "feed" the dog - reset the watchdog timer
// by writing this required bit pattern
    void kick();
    
    int getFlg ();

    void attach (void (*fptr)(void), float s);

    template<typename T>
    void attach (T *object, void (*fptr)(void), float s);

    void sleep ();
    void deepSleep ();
    void powerDown ();

private:
    static FunctionPointer _fptr;
    static void isr_wdt(void);
};

#endif
