#include "mbed.h"
#include "dbg.h"
#include "USBMSC.h"

#include "msc_bot.h"
#include "SDFileSystem.h"
#include <new>

Serial pc(USBTX, USBRX);
DigitalOut myled(LED1);
SDFileSystem sd(p5, p6, p7, p8, "sd");

USBMSC usbdev;
//USBMSC usbdev(0xFFFF, 0x0003, 0x0100);

extern "C"
void HardFault_Handler() {
    printf("Hard Fault!\n");
    exit(-1);
}

void no_memory () {
    printf("panic: can't allocate to memory!\r\n");
    exit(-1);
}

void msc_evt (uint8_t endpoint) {
    switch (endpoint) {
    case EPBULK_OUT:
        MSCBotBulkOut();
        break;
    case EPBULK_IN:
        MSCBotBulkIn();
        break;
    case 0xFF:
        MSCBotReset();
        break;
    }
}

int main() {
    pc.baud(115200);
    
    set_new_handler(no_memory); // new handler function

    FILE *fp = fopen("/sd/test.txt", "r");
    if(fp) {
        int c;
        c = fgetc(fp);
        pc.printf("file: %c\r\n", c);
        fclose(fp); 
    }

    MSCBotReset();
    usbdev.attach(&msc_evt);

    pc.printf("begin\r\n");

    while(1) {
    
        myled = 1;
        wait(0.5);
        myled = 0;
        wait(0.5);
    }
}
