
#ifndef USBMSC_H
#define USBMSC_H

/* These headers are included for child class. */
#include "USBEndpoints.h"
#include "USBDescriptor.h"
#include "USBDevice_Types.h"

#include "USBDevice.h"

#define DEFAULT_CONFIGURATION (1)

class USBMSC: public USBDevice {
public:

    /**
    * Constructor
    *
    * @param vendor_id Your vendor_id
    * @param product_id Your product_id
    * @param product_release Your preoduct_release
    */
    USBMSC(uint16_t vendor_id = 0x1FC9, uint16_t product_id = 0x1002, uint16_t product_release = 0x0100);
    
    /*
    * Get configuration descriptor
    *
    * @returns pointer to the configuration descriptor
    */
    virtual uint8_t * configurationDesc();
    virtual uint8_t * deviceDesc();
    
    virtual bool USBCallback_setConfiguration(uint8_t configuration);
    
    virtual bool USBCallback_request ();

    void attach(void (*fptr)(uint8_t));

    void setTransferData (uint8_t *buf, int len);

protected:
    virtual bool EPBULK_OUT_callback();
    virtual bool EPBULK_IN_callback();

private:
    void (*msc_evt)(uint8_t);

};

#endif
