/*****************************************************************************\
*              efs - General purpose Embedded Filesystem library              *
*          --------------------- -----------------------------------          *
*                                                                             *
* Filename : sd.c                                                             *
* Revision : Initial developement                                             *
* Description : This file contains the functions needed to use efs for        *
*               accessing files on an SD-card.                                *
*                                                                             *
* This library is free software; you can redistribute it and/or               *
* modify it under the terms of the GNU Lesser General Public                  *
* License as published by the Free Software Foundation; either                *
* version 2.1 of the License, or (at your option) any later version.          *
*                                                                             *
* This library is distributed in the hope that it will be useful,             *
* but WITHOUT ANY WARRANTY; without even the implied warranty of              *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU           *
* Lesser General Public License for more details.                             *
*                                                                             *
*                                                    (c)2005 Michael De Nil   *
*                                                    (c)2005 Lennart Yseboodt *
\*****************************************************************************/

/*
    2006, Bertrik Sikken, modified for LPCUSB
*/
/*
 *  Modified for mbed NXP LPC1768 & LPCXpresso board
 *
 *  NOT USE efs library
 *  USE FatFs interface routine
 *
 *  original    LPC214x USB stack beta by bertrik
 *              target-20070727.tar.gr (119.5KB)
 *              http://sourceforge.net/projects/lpcusb/
 *  By Kenji Arai / JH1PJL on September 25th, 2010
 *      October 3rd, 2010
 */

//#define DEBUG
#include "dbg.h"
#include "mbed.h"

#include "blockdev.h"
#include "SDFileSystem.h"


extern SDFileSystem sd;

// Get Device media size
uint32_t BlockDevGetSize()
{
    DBG("BlockDevGetSize\r\n");
    return sd.disk_sectors() * 512;
}

// Initialize
int BlockDevInit(void)
{
    DBG("BlockDevInit\r\n");
//    return sd.disk_initialize(0);    // Drive # = 0
    return 0;
}

int BlockDevWrite(uint32_t dwAddress, uint8_t * pbBuf)
{
    //( drive #=0, data buffer to write the data, sector's address, Number of Blocks=1 )
    return sd.disk_write((char*)pbBuf, dwAddress);    // return=0 -> success
}

int BlockDevRead(uint32_t dwAddress, uint8_t * pbBuf)
{
    //( drive #=0, data buffer to read the data, sector's address, Number of Blocks=1 )
    return sd.disk_read((char*)pbBuf, dwAddress);    // return=0 -> success
}
