/* USB_MIDI.h */
/* MIDI device example */
/* Copyright (c) 2011 ARM Limited. All rights reserved. */

#ifndef USBMIDI_H
#define USBMIDI_H

/* These headers are included for child class. */
#include "USBEndpoints.h"
#include "USBDescriptor.h"
#include "USBDevice_Types.h"

#include "USBDevice.h"
#include "MIDIMessage.h"

#define DEFAULT_CONFIGURATION (1)

/** 
* USBMIDI example
*
* @code
* #include "mbed.h"
* #include "USBMIDI.h"
*
* USBMIDI midi;
*
* int main() {            
*    while (1) {    
*        for(int i=48; i<83; i++) {     // send some messages!
*            midi.write(MIDIMessage::NoteOn(i));
*            wait(0.25);
*            midi.write(MIDIMessage::NoteOff(i));
*            wait(0.5);
*        }
*    }
* }
* @endcode
*/
class USBMIDI: public USBDevice {
public:

    /**
    * Constructor
    *
    * @param vendor_id Your vendor_id
    * @param product_id Your product_id
    * @param product_release Your preoduct_release
    */
    USBMIDI(uint16_t vendor_id = 0x0700, uint16_t product_id = 0x0101, uint16_t product_release = 0x0001);
    
    /*
    * Get string product descriptor
    *
    * @returns pointer to the string product descriptor
    */
    virtual uint8_t * stringIproductDesc();
    
    /*
    * Get string interface descriptor
    *
    * @returns pointer to the string interface descriptor
    */
    virtual uint8_t * stringIinterfaceDesc();
    
    /*
    * Get configuration descriptor
    *
    * @returns pointer to the configuration descriptor
    */
    virtual uint8_t * configurationDesc();
    
    /**
     * Send a MIDIMessage
     *
     * @param m The MIDIMessage to send
     */    
    void write(MIDIMessage m);

    /**
     * Attach a callback for when a MIDIEvent is received
     *
     * @param fptr function pointer
     */
    void attach(void (*fptr)(MIDIMessage));
    
    virtual bool USBCallback_setConfiguration(uint8_t configuration);
    
protected:
    virtual bool EPBULK_OUT_callback();

private:
    void (*midi_evt)(MIDIMessage);

};

#endif

