#include "mbed.h"
#include "USBCDC.h"

Serial pc(USBTX, USBRX);
DigitalOut myled(LED1);

USBCDC usbdev(0x1FC9, 0x2002, 0x0100);
//USBCDC usbdev(0xFFFF, 0x0005, 0x0100);

char cdc_data[61];
volatile int cdc_len = 0;

void cdc_evt (char *data, int len) {
    memcpy(cdc_data, data, len);
    cdc_len = len;
}

int main() {
    pc.baud(115200);
    pc.printf("begin\r\n");
    
    usbdev.attach(&cdc_evt);
    
    while(1) {
    
        if (cdc_len) {
            myled = 1;
            pc.printf("<%s>\r\n", cdc_data);
            usbdev.write(EPBULK_IN, (uint8_t*)cdc_data, cdc_len, MAX_PACKET_SIZE_EPBULK);
            cdc_len = 0;
            myled = 0;
        }
    }
}
