
#ifndef USBCDC_H
#define USBCDC_H

/* These headers are included for child class. */
#include "USBEndpoints.h"
#include "USBDescriptor.h"
#include "USBDevice_Types.h"

#include "USBDevice.h"

#define DEFAULT_CONFIGURATION (1)

class USBCDC: public USBDevice {
public:

    /**
    * Constructor
    *
    * @param vendor_id Your vendor_id
    * @param product_id Your product_id
    * @param product_release Your preoduct_release
    */
    USBCDC(uint16_t vendor_id = 0xFFFF, uint16_t product_id = 0x0005, uint16_t product_release = 0x0100);
    
    /*
    * Get string product descriptor
    *
    * @returns pointer to the string product descriptor
    */
    virtual uint8_t * stringIproductDesc();
    
    /*
    * Get string interface descriptor
    *
    * @returns pointer to the string interface descriptor
    */
    virtual uint8_t * stringIinterfaceDesc();
    
    /*
    * Get configuration descriptor
    *
    * @returns pointer to the configuration descriptor
    */
    virtual uint8_t * configurationDesc();
    virtual uint8_t * deviceDesc();
    
    virtual bool USBCallback_setConfiguration(uint8_t configuration);
    
    virtual bool USBCallback_request ();

    void attach(void (*fptr)(char*, int));

protected:
    virtual bool EPBULK_OUT_callback();

private:
    void (*cdc_evt)(char*, int);

};

#endif
