#include "mbed.h"
#include "USBHostXpad.h"

Serial pc(USBTX, USBRX);
DigitalOut led(LED1);
volatile int poll = 0;

void onXpadEvent (int buttons, int stick_lx, int stick_ly, int stick_rx, int stick_ry, int trigger_l, int trigger_r) {
    std::printf("Xpad: %04x %-5d %-5d %-5d %-5d %02x %02x\r\n", buttons, stick_lx, stick_ly, stick_rx, stick_ry, trigger_l, trigger_r);
    poll = 0;
}

void xpad_task(void const *) {
    USBHostXpad xpad;

    while(1) {
        // try to connect a Xbox 360 Wireless Controller
        while(!xpad.connect())
            Thread::wait(500);
    
        // when connected, attach handler called on xpad event
        xpad.attachEvent(onXpadEvent);

        xpad.led(USBHostXpad::LED_ROTATE);
        Thread::wait(500);
        xpad.rumble(0xff, 0);
        Thread::wait(500);
        xpad.rumble(0, 0xff);
        Thread::wait(500);
        xpad.rumble(0, 0);
        Thread::wait(500);
        xpad.led(USBHostXpad::LED1_ON);

        // wait until the mouse is disconnected
        while(xpad.connected()) {
            Thread::wait(500);
            poll ++;
            if (poll > 10) {
                xpad.restart();
                poll = 0;
            }
        }
    }
}


int main() {
    pc.baud(115200);
    pc.printf("----------\r\n");
    Thread xpadTask(xpad_task, NULL, osPriorityNormal, 1024 * 4);
    while(1) {
        led=!led;
        Thread::wait(500);
    }
}

