/*
 * mbed Tiny SNTP(NTP) Client
 * Copyright (c) 2011 Hiroshi Suga
 * Released under the MIT License: http://mbed.org/license/mit
 */

/** @file
 * @brief Tiny DNS Resolver
 */

#ifndef TinySNTP_h
#define TinySNTP_h

#include <inttypes.h>

#define DEBUG

#define NTP_PORT 123
#define NTP_SRC_PORT 50420
#define NTP_TIMESTAMP_DELTA 2208988800ull
#define NTP_TIMEOUT 15000 // ms

struct SNTPPacket {
    uint8_t info;
    uint8_t stratum;
    uint8_t poll;
    uint8_t precision;

    uint32_t rootDelay;
    uint32_t rootDispersion;
    uint32_t refId;

    uint32_t refTm_s;
    uint32_t refTm_f;
    uint32_t origTm_s;
    uint32_t origTm_f;
    uint32_t rxTm_s;
    uint32_t rxTm_f;
    uint32_t txTm_s;
    uint32_t txTm_f;
} __attribute__((packed));

int createSntpRequest (char*);
int getSntpResponse (const char*, uint32_t *time);

/** resolv host by name
 * @param name NTP server
 * @param tim time (return)
 * @return 0:success, -1:failue
 */
int ntpdate (const char* name, uint32_t *tim);

#endif
