#include "mbed.h"
#include "EthernetNetIf.h"
#include "TinySNTP.h"

DigitalOut myled(LED1);
Serial pc(USBTX, USBRX);
EthernetNetIf eth;

int main () {
    EthernetErr ethErr;
    uint32_t t;
    struct tm *tm_buf;
    time_t seconds = time(NULL);

    myled = 1;
    printf("Time as a string = %s\r\n", ctime(&seconds));

    ethErr = eth.setup();
    if(ethErr) {
        return -1;
    }

    ntpdate("ntp1.sakura.ad.jp", &t);

    t = t + 60 * 60 * 9; // JST
    tm_buf = localtime((time_t*)&t);
    printf("now: %04d/%02d/%02d %02d:%02d:%02d\n", 1900 + tm_buf->tm_year, tm_buf->tm_mon + 1, tm_buf->tm_mday,
                            tm_buf->tm_hour, tm_buf->tm_min, tm_buf->tm_sec);

    myled = 0;
    return 0;
}
