#include "mbed.h"
#include "EthernetNetIf.h"
#include "TCPSocket.h"
#include "TinySMTP.h"

#define SMTP "mail.domain.name"
#define PORT 587 // or 25
#define FROM "from@domain.name"
#define TO "to@domain.name"
#define USER "authuser"
#define PWD "password"
#define SUBJECT "mail test"
#define BODY "TEST TEST"

DigitalOut myled(LED1);
Serial pc(USBTX, USBRX);
EthernetNetIf eth;

int main () {
    EthernetErr ethErr;
    Host host;
    int r;
    char data[500];

    myled = 1;

    strcpy(data, "From: " FROM "\r\nTo: " TO "\r\n");
    strcat(data, "Subject: " SUBJECT "\r\n\r\n" BODY "\r\n");

    ethErr = eth.setup();
    if(ethErr) {
        return -1;
    }

    host.setName(SMTP);
    host.setPort(PORT);
    r = sendmail(FROM, TO, data, &host, USER, PWD);

    if (r) {
        printf("error\r\n");
    } else {
        printf("sent\r\n");
    }

    myled = 0;
    return 0;
}
