/*
 * mbed Tiny DNS Resolver
 * Copyright (c) 2011 Hiroshi Suga
 * Released under the MIT License: http://mbed.org/license/mit
 */

/** @file
 * @brief Tiny DNS Resolver
 */

#ifndef TinyResolver_h
#define TinyResolver_h

#include <inttypes.h>

#define DEBUG

#define DNS_PORT 53
#define DNS_SRC_PORT 1234
#define DNS_TIMEOUT 15000 // ms

// dns
#define DNS_QUERY_A 1
#define DNS_QUERY_NS 2
#define DNS_QUERY_CNAME 5
#define DNS_QUERY_PTR 12
#define DNS_QUERY_MX 15
#define DNS_QUERY_AAAA 28
#define DNS_QUERY_ANY 255
#define DNS_CLASS_IN 1

struct DnsHeader {
        uint16_t id; 
        uint16_t flags; 
        uint16_t questions; 
        uint16_t answers; 
        uint16_t authorities; 
        uint16_t additional; 
};

struct DnsQuestionEnd { 
        uint16_t type; 
        uint16_t clas; 
};

struct DnsAnswer {
        uint16_t name; 
        uint16_t type; 
        uint16_t clas; 
        uint32_t ttl; 
        uint16_t length; 
} __attribute__((packed)); 

int createDnsRequest (char *name, char *buf);
int getDnsResponse (const char *buf, int len, uint32_t *addr);

/** resolv host by name
 * @param nameserver DNS server
 * @param name hostname
 * @param addr IP address (return)
 * @return 0:success, -1:failue
 */
int getHostByName (IpAddr nameserver, const char *name, uint32_t *addr);

#endif