#include "mbed.h"
#include "EthernetNetIf.h"
#include "TinyResolver.h"

DigitalOut myled(LED1);
Serial pc(USBTX, USBRX);
EthernetNetIf eth; 

int main () {
    EthernetErr ethErr;
    uint32_t addr;

    myled = 1;

    ethErr = eth.setup();
    if(ethErr) {
        return -1;
    }

	getHostByName(IpAddr(192,168,1,1), "mbed.org", &addr);

	printf("IP address: %d.%d.%d.%d\r\n", (addr >> 24) & 0xff, (addr >> 16) & 0xff, (addr >> 8) & 0xff, addr & 0xff);

    myled = 0;
	return 0;
}
