#include "mbed.h"
#include "EthernetNetIf.h"
#include "TCPSocket.h"
#include "TinyHTTP.h"

DigitalOut myled(LED1);
Serial pc(USBTX, USBRX);
EthernetNetIf eth;


int pachube (int feedid, char *apikey, char *buf) {
	Host host;
	char uri[40], head[160];

	// header
	snprintf(head, sizeof(head), "Content-type: text/csv\r\nX-PachubeApiKey: %s\r\n", apikey);

	// uri
	snprintf(uri, sizeof(uri), "/v1/feeds/%d.csv?_method=put", feedid);

	host.setName("api.pachube.com");
	host.setPort(HTTP_PORT);
	return httpRequest(METHOD_POST, &host, uri, head, buf) == 200 ? 0 : -1;
}

int twitter (char *msg, char *user, char *pwd) {
	Host host;
	char buf[300], head[160];

	// header
	createauth(user, pwd, head, sizeof(head));
	strncat(head, "Content-type: application/x-www-form-urlencoded\r\n", sizeof(head) - strlen(head));

	// post data
	strcpy(buf, "status=");
	urlencode(msg, &buf[strlen(buf)], sizeof(buf) - strlen(buf));

	host.setName("api.supertweet.net");
	host.setPort(HTTP_PORT);
	return httpRequest(METHOD_POST, &host, "/1/statuses/update.xml", head, buf) == 200 ? 0 : -1;
}

int main () {
    EthernetErr ethErr;
    Host host;
    int r;

    myled = 1;
//    pc.baud(115200);

    ethErr = eth.setup();
    if(ethErr) {
        return -1;
    }

    host.setName("mbed.org");
    r = httpRequest(METHOD_GET, &host, "/", NULL, NULL);

//    r = twitter("test from #mbed TinyHTTP", "username", "password");

//    r = pachube(99999, "api key", "1000,30,70");

/*
    host.setName("www.domain.name");
    r = httpRequest(METHOD_POST, &host, "/xxx.cgi", "Content-Type: application/x-www-form-urlencoded\r\n", "key=value&key2=value2");
*/
    printf("status %d\r\n", r);

    myled = 0;
    return 0;
}
