#include "mbed.h"

Serial pc(USBTX, USBRX);
DigitalOut led1(LED1), led2(LED2), led3(LED3);

DigitalIn mo1(p20), mo2(p17);
DigitalOut ck1(p19), cw1(p18), ck2(p16), cw2(p15);
DigitalOut m1(p14), m2(p13);

int main() {

    pc.baud(115200);
    pc.printf("stepper\r\n");

    mo1.mode(PullUp); // motor1 MO
    mo2.mode(PullUp); // motor2 MO

    // micro step
    m1 = 1; // motor1,2 M1
    m2 = 1; // motor1,2 M2

    cw1 = 0; // motor1 CW/CCW
    cw2 = 1; // motor2 CW/CCW

    while(1) {
        led1 = ! led1;
        // pulse
        ck1 = ! ck1; // motor1 CK
        ck2 = ! ck2; // motor2 CK
        // monitor
        led2 = ! mo1;
        led3 = ! mo2;

        wait_us(250);
    }
}
