#include "mbed.h"

DigitalOut myled(LED1);
Serial pc(USBTX, USBRX);

Serial ser(p28, p27);
LPC_UART1_TypeDef *uart = (LPC_UART1_TypeDef*)LPC_UART2;

int main() {
    int fdiv, baud;

    pc.baud(115200);
    pc.printf("Auto-baud start...\r\n");
    myled = 1;

    uart->LCR |= (1<<7);
    uart->DLL = 0;
    uart->DLM = 0;
    uart->LCR &= ~(1<<7);
    uart->FDR = 0x10;
//    uart->ACR = (1<<9)|(1<<8)|(1<<2)|(1<<0); // Auto-baud start, mode 0
    uart->ACR = (1<<9)|(1<<8)|(1<<2)|(1<<1)|(1<<0); // Auto-baud start, mode 1
    while (uart->ACR & (1<<0));

    uart->LCR |= (1<<7);
    fdiv = uart->DLM * 256 + uart->DLL;
    uart->LCR &= ~(1<<7);
    baud = SystemCoreClock / (16 * fdiv);
    pc.printf("Baudrate: %d\r\n", baud);

    myled = 0;
    for (;;) {
        if (pc.readable()) {
            ser.putc(pc.getc());
        }
        if (ser.readable()) {
            pc.putc(ser.getc());
        }
    }
}
