/* Copyright (C) 2012 mbed.org, MIT License
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software
 * and associated documentation files (the "Software"), to deal in the Software without restriction,
 * including without limitation the rights to use, copy, modify, merge, publish, distribute,
 * sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all copies or
 * substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING
 * BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
/*
 * Modified by 2013 Hiroshi Suga, MIT License
 */

#ifndef CIRCBUFFER_H_
#define CIRCBUFFER_H_

#define WINDOW_SIZE 64
#define WINDOW_MASK 0x3f

#include "SerRAM.h"

class CircBuffer {
public:
    CircBuffer(int length);

    bool isFull();

    bool isEmpty();

    bool queue(char k);
    
    void flush();
    

    uint32_t available();

    uint32_t use();

    bool dequeue(char * c);

    void dump();

private:
    volatile uint32_t write;
    volatile uint32_t read;
    uint32_t size;
    char buf_w[WINDOW_SIZE];
    char buf_r[WINDOW_SIZE];

    SerRAM * _ram;
    uint32_t ram_addr;
    uint32_t ram_w, ram_r;
    
    static int xalloc(int size);
};

#endif
