/*
 * Memory File System Library, for SPI PRAM NP8P128A13 (Micron)
 * Copyright (c) 2012 Hiroshi Suga
 * Released under the MIT License: http://mbed.org/license/mit
 */

#include "mbed.h"
#include "PRAMFileSystem.h"

DigitalOut myled(LED1);
Serial pc(USBTX, USBRX);

PRAMFileSystem mfs(p11, p12, p13, p14, "mfs"); // mosi, miso, sclk, cs
DigitalOut hold(p15), reset(p16);


int main() {
    int i;
    char buf[64];
    DIR *d;
    struct dirent *p;
    FILE *fp;

    hold = 1;
    reset = 0;
    pc.baud(115200);
    wait_ms(10);
    reset = 1;
    wait_ms(500);

    mfs.format();

    mkdir("/mfs/test", 0777);
    
    fp = fopen("/mfs/hello_world.txt", "w");
    if (fp) {
        fputs("Hello PRAM!", fp);
        fclose(fp);
    }

    d = opendir("/mfs");
    if (d) {
        while (p = readdir(d)) {
            printf(" - %s\r\n", p->d_name);
        }
    } else {
        printf("Could not open directory!\n");
    }
    closedir(d);

    fp = fopen("/mfs/hello_world.txt", "r");
    if (fp) {
        fgets(buf, sizeof(buf), fp);
        fclose(fp);
        printf("[%s]\r\n", buf);
    }
}
