/*
 * SPI RAM 23LC1024 (Microchip)
 *   1Mbit
 *   with DMA ( http://mbed.org/users/AjK/code/MODDMA/ )
 */
#include "mbed.h"
#include "SerRAM.h"
#include "CBuffer_SRAM.h"

#define FIFO_SIZE 250

DigitalOut myled(LED1);
Serial pc(USBTX, USBRX);

SerRAM memory(p5, p6, p7, p18, 1024);
CircBuffer fifo(FIFO_SIZE);

extern "C" void HardFault_Handler() {
    register unsigned int _msp __asm("msp");
    printf("Hard Fault! address: %08x\r\n", *((unsigned int *)(_msp + 24)));
    exit(-1);
}  

int main() {
    char c;
    int i, r, w;

    pc.baud(115200);
    wait_ms(500);
    pc.printf("*** SRAM TEST ***\r\n");

    printf("- FULL\r\n", w);
    for (w = 0; w < 256; w ++) {
        if (fifo.queue(w) == false) {
            printf("write full %d\r\n", w);
            break;
        }
    }
    for (r = 0; r < 256; r ++) {
        if (fifo.dequeue(&c) == false) {
            printf("read end %d\r\n", r);
            break;
        }
        if (c != r) {
            printf("data error %d != %d\r\n", r, c);
            return -1;
        }
    }
    printf("- ok\r\n", w);

    fifo.flush();

    printf("- write > read\r\n", w);
    for (w = 1; w < 60; w ++) {
        if (fifo.queue(w) == false) {
            printf("write full %d\r\n", w);
            break;
        }
    }
    for (r = 1; r < 40; r ++) {
        if (fifo.dequeue(&c) == false) {
            printf("read end %d\r\n", r);
            break;
        }
        if (c != r) {
            printf("data error %d != %d\r\n", r, c);
            return -1;
        }
    }
    for (; w < 120; w ++) {
        if (fifo.queue(w) == false) {
            printf("write full %d\r\n", w);
            break;
        }
    }
    for (; r < 121; r ++) {
        if (fifo.dequeue(&c) == false) {
            printf("read end %d\r\n", r);
            break;
        }
        if (c != r) {
            printf("data error %d != %d\r\n", r, c);
            return -1;
        }
    }
    printf("- ok\r\n", w);

    fifo.flush();

    printf("- write < read\r\n", w);
    for (w = 0; w < 250; w ++) {
        if (fifo.queue(w) == false) {
            printf("write full %d\r\n", w);
            break;
        }
    }
    for (r = 0; r < 240; r ++) {
        if (fifo.dequeue(&c) == false) {
            printf("read end %d\r\n", r);
            break;
        }
        if (c != (r & 0xff)) {
            printf("data error %d != %d\r\n", r, c);
            return -1;
        }
    }
    for (; w < 270; w ++) {
        if (fifo.queue(w) == false) {
            printf("write full %d\r\n", w);
            break;
        }
    }
    for (; r < 260; r ++) {
        if (fifo.dequeue(&c) == false) {
            printf("read end %d\r\n", r);
            break;
        }
        if (c != (r & 0xff)) {
            printf("data error %d != %d\r\n", r, c);
            return -1;
        }
    }
    for (; w < 400; w ++) {
        if (fifo.queue(w) == false) {
            printf("write full %d\r\n", w);
            break;
        }
    }
    for (; r < 401; r ++) {
        if (fifo.dequeue(&c) == false) {
            printf("read end %d\r\n", r);
            break;
        }
        if (c != (r & 0xff)) {
            printf("data error %d != %d\r\n", r, c);
            return -1;
        }
    }
    printf("- ok\r\n", w);

}
