/*
 * SPI RAM 23LC1024 (Microchip)
 *   1Mbit
 */
#include "mbed.h"

#define CMD_READ    0x03
#define CMD_WRITE   0x02
#define CMD_RDMR    0x05
#define CMD_WRMR    0x01

DigitalOut myled(LED1);
Serial pc(USBTX, USBRX);

SPI spi(p11, p12, p13); // mosi, miso, sclk
DigitalOut cs(p17), hold(p18);

int ram_write (int addr, char *buf, int len) {
    int i;

    cs = 0;
    spi.write(CMD_WRITE);
    spi.write((addr >> 16) & 0xff);
    spi.write((addr >> 8) & 0xff);
    spi.write(addr & 0xff);

    for (i = 0; i < len; i ++) {
        spi.write(buf[i]);
    }
    cs = 1;
    return i;
}

int ram_read (int addr, char *buf, int len) {
    int i;

    cs = 0;
    spi.write(CMD_READ);
    spi.write((addr >> 16) & 0xff);
    spi.write((addr >> 8) & 0xff);
    spi.write(addr & 0xff);

    for (i = 0; i < len; i ++) {
        buf[i] = spi.write(0);
    }
    cs = 1;
    return i;
}

int main() {
    int i;
    char buf[256];
    Timer t;

    cs = 1;
    hold = 1;
    pc.baud(115200);
    spi.frequency(16000000);
    wait_ms(500);
    
    cs = 0;
    spi.write(CMD_RDMR);
    printf("RAM mode: %02x\r\n", spi.write(0));
    cs = 1;
    
    printf("\r\nHELLO test\r\n");
    
    printf("RAM write\r\n");
    strcpy(buf, "Hello!");
    ram_write(0, buf, 6);
    
    for (i = 0; i < 256; i ++) {
        buf[i] = i;
    }
    ram_write(6, buf, 256);

    wait(1);
    memset(buf, 0, 256);
    
    printf("RAM read\r\n");
    ram_read(0, buf, 256);
    for (i = 0; i < 256; i ++) {
        printf(" %02x", buf[i]);
        if ((i & 0x0f) == 0x0f)
            printf("\r\n");
    }

    wait(1);

    printf("\r\nWrite/Read time\r\n");

    printf("RAM write\r\n");
    t.reset();
    t.start();
    for (i = 0; i < 0x20000; i += 256) {
        buf[0] = (i >> 8) & 0xff;
        ram_write(i, buf, 256);
        if ((i & 0x0fff) == 0) printf(".");
    }
    t.stop();
    printf("\r\ntime %f, %f KBytes/sec\r\n", t.read(), (float)0x20000 / 1024 / t.read());

    wait(1);

    printf("RAM read\r\n");
    t.reset();
    t.start();
    for (i = 0; i < 0x20000; i += 256) {
        ram_read(i, buf, 256);
        if (buf[0] != ((i >> 8) & 0xff)) {
            printf("error %d\r\n", i);
            break;
        }
        if ((i & 0x0fff) == 0) printf(".");
    }
    t.stop();
    printf("\r\ntime %f, %f KBytes/sec\r\n", t.read(), 0x20000 / 1024 / t.read());

}
