/*
 * Can not be compiled with mbed.org.
 * I used MDK-ARM Lite + LPC-LINK2.
 */

#include "LPC8xx.h"

void SwitchMatrix_Init (void);

void sleep () {
    LPC_PMU->PCON = 0;
    SCB->SCR &= ~(1<<2);
    __WFI();
}

void deep_sleep () {
    LPC_SYSCON->PDAWAKECFG = LPC_SYSCON->PDRUNCFG;
    LPC_PMU->PCON = (1<<0);
    SCB->SCR |= (1<<2);
    __WFI();
}

void power_down () {
    LPC_SYSCON->PDAWAKECFG = LPC_SYSCON->PDRUNCFG;
    LPC_PMU->PCON = (2<<0);
    SCB->SCR |= (1<<2);
    __WFI();
}

void WKT_IRQHandler () {
    if (LPC_WKT->CTRL & (1<<1)) {
        LPC_GPIO_PORT->CLR0 = (1<<7); // R on
        LPC_WKT->CTRL |= (1<<2)|(1<<1);
    } else {
        LPC_GPIO_PORT->CLR0 = (1<<17); // G on
    }
}

int main(void) {
    int i;

    SwitchMatrix_Init();

    // GPIO
    LPC_SYSCON->SYSAHBCLKCTRL |= (1<<6);
    LPC_GPIO_PORT->DIR0 = (1<<17)|(1<<16)|(1<<7);
    LPC_GPIO_PORT->SET0 = (1<<17)|(1<<16)|(1<<7);
    LPC_GPIO_PORT->CLR0 = (1<<16); // B on
    for (i = 0; i < 500000; i ++) __NOP();
    LPC_GPIO_PORT->SET0 = (1<<16); // B off

    // WKT
    LPC_SYSCON->SYSAHBCLKCTRL |= (1<<9);
    LPC_SYSCON->PRESETCTRL &= ~(1<<9);
    LPC_SYSCON->PRESETCTRL |= (1<<9);
    LPC_PMU->DPDCTRL |= (1<<2);
    LPC_SYSCON->STARTERP1 |= (1<<15);
    LPC_WKT->CTRL = (1<<2)|(1<<1)|(1<<0);
    LPC_WKT->COUNT = 10000 * 3;
    NVIC_EnableIRQ(WKT_IRQn);
    __enable_irq();

//  sleep();
//  deep_sleep();
    power_down();

    for (i = 0; i < 500000; i ++) __NOP();
    LPC_GPIO_PORT->SET0 = (1<<7); // R off
    for (;;) {
        __NOP();
    }
}
