#include "mbed.h"

Serial pc(USBTX, USBRX);

DigitalOut led1(LED1), led2(LED2), led3(LED3), led4(LED4);

DigitalOut line1a(p12), line1b(p13);
DigitalOut line2a(p14), line2b(p15);
DigitalIn hook1(p11), hook2(p16);

int main() {
    led1 = 1;
    line1a = 1;
    line2a = 1;
    hook1.mode(PullUp);
    hook2.mode(PullUp);

    for(;;) {

        led3 = led4 = hook2 ? 0 : 1;

        if (pc.readable() && pc.getc() == '1')
          for (;;) {
            led2 = 1;
            for (int i = 0; i < 16; i ++) { 
                line1a = 0; line2a = 0;
                wait_ms(6);
                led4 = hook2 ? 0 : 1;
                line1b = 1; line2b = 1;
                wait_ms(25);
                led3 = hook2 ? 0 : 1;
                line1b = 0; line2b = 0;
                wait_ms(6);
                line1a = 1; line2a = 1;
                wait_ms(25);
                if (! hook2) break;
            }
            wait(2);
            if (pc.readable() && pc.getc() == '0') {
                led2 = 0;
                break;
            }
        }
    }
}
