#include "mbed.h"
#include "EthernetNetIf.h"
#include "UDPSocket.h"
#include "RingBuffer.h"
#include "ulaw.h"

#define FREQ 8000
#define MTU 1500
#define MTU2 700
#define BUFSIZE (MTU * 2)
#define UDPPORT 10080

//EthernetNetIf eth;
EthernetNetIf eth(IpAddr(192,168,2,101), IpAddr(255,255,255,0), IpAddr(192,168,2,1), IpAddr(192,168,2,1));
UDPSocket dupsock;
Host remote;
Ticker ticker;

DigitalIn sw1(p29);
DigitalIn sw2(p30);
DigitalOut led0(p19), led1(LED1), led2(LED2), led3(LED3), led4(LED4);
AnalogIn adc(p17);
AnalogOut dac(p18);

DigitalOut line1a(p12), line1b(p13);
DigitalOut line2a(p14), line2b(p15);
DigitalIn hook1(p11), hook2(p16);
DigitalOut mixlocal(p21), mixline(p22), micsp(p23);
DigitalOut led_y(p25), led_g(p26);
DigitalIn eth_link(P1_25), eth_speed(P1_26);

RingBuffer buf1(BUFSIZE);
RingBuffer buf2(BUFSIZE);
int connect;
int timeout;

// UDP
void onLisnerEvent (UDPSocketEvent e) {
    int len;
    char buf[MTU];
    Host recv;

    if (e != UDPSOCKET_READABLE) return;

    // Mf[^擾
    len = dupsock.recvfrom(buf, MTU, &recv);

    // ڑֈڍs
    if (connect == 0) {
        remote = recv;
        IpAddr ip = remote.getIp();
//        printf("connection from %d.%d.%d.%d\n", ip[0], ip[1], ip[2], ip[3]);

        connect = 1;
//    mixline = 1;
    mixlocal = 1;
    micsp = 1;
        led2 = 1;
    }

    // ڑ̑悩`FbNAf[^ۑ//
//    if (remote.getIp() == recv.getIp()) {
        buf2.put(buf, len);
        timeout = FREQ;
        led3 = led3 ? 0 : 1;
//    }
}

// TvO荞 8KHz
void int_sample () {
    char c;

    // Mf[^Đ
    if (! buf2.get(c)) {
        dac.write_u16(ulaw2pcm(c));
//        dac.write_u16((unsigned short)c << 8);
    }

    // Mf[^
    if (connect && buf1.available()) {
        buf1.put(pcm2ulaw(adc.read_u16()));
    }

    if (timeout) timeout --;
}


int main () {
    int len, last;
    char buf[MTU];
    EthernetErr r;
    Host send;
    
    connect = 0;
    timeout = 0;

    // lbg[N
    led_g = eth_link ? 0 : 1;
    led_y = eth_speed ? 0 : 1;
    r = eth.setup();
    if (r) {
        printf("Error %d in setup.\n", r);
        return -1;
    }
    dupsock.setOnEvent(&onLisnerEvent);
//    dupsock.bind(Host(IP_ADDR_ANY, UDPPORT));
    dupsock.bind(Host(eth.getIp(), UDPPORT));

    // ݊Jn
    ticker.attach_us(&int_sample, 1000000UL / FREQ);
    led0 = 1;
    led1 = 1;
    
    line1a = 1;
    hook1.mode(PullUp);
    hook2.mode(PullUp);

    last = hook1;
    for (;;) {
        led4 = hook1 ? 0 : 1;
        led_g = eth_link ? 0 : 1;
        led_y = eth_speed ? 0 : 1;

        if (hook1 != last) {
            buf[0] = hook1;
            dupsock.sendto(buf, 1, &remote);
            last = hook1;
        }
/*
        // Mobt@܂瑗M
        if (connect && buf1.use() >= MTU) {
            len = buf1.get(buf, MTU);
            if (len > 0)
                dupsock.sendto(buf, len, &remote);
        }
*/
/*
        // ڑ^CAEg or ؒf{^
        if (connect && (! timeout || ! sw2)) {
            led1 = 0;
            connect = 0;
            buf1.clear();
            buf2.clear();
        }

        // ڑ{^
        if (! connect && ! sw1) {
            send = Host(IpAddr(192,168,0,4), UDPPORT, NULL);
            dupsock.bind(send);
            buf1.clear();
            buf2.clear();
            timeout = FREQ;
            connect = 1;
        }
*/
        Net::poll();
    }

}

