/*
 * mbed library for RingBuffer
 * Copyright (c) 2010 Hiroshi Suga
 * Released under the MIT License: http://mbed.org/license/mit
 */

#ifndef RingBuffer_H
#define RingBuffer_H

#include "mbed.h"

class RingBuffer {
public:
    RingBuffer (int p_size);
    ~RingBuffer ();

    int put (char);
    int put (char *, int);
    int get (char &);
    int get (char *, int);
    void clear ();
    int available ();
    int use ();

private:
    char *buf;
    int size;
    int addr_w, addr_r;
};

#endif
