#include "phone.h"
#include "mbed.h"
#include "EthernetNetIf.h"
#include "UDPSocket.h"
#include "RingBuffer.h"
#include "ulaw.h"

struct ipline_header {
    unsigned long ident;
    unsigned short num;
    enum PhoneType target;
    enum Mode mode;
    enum Status status;
};

struct ipline_packet {
    struct ipline_header header;
    unsigned short len;
    char data[DATA_SIZE];
};


/**
 * @brief IpLine class
 */
class IpLine {
public:
    IpLine (EthernetNetIf *, AnalogOut, AnalogIn);

    void intr ();
    void poll ();
    int enter (enum Mode);
    int scan (enum Scan);
    void settarget (enum PhoneType, char *);

private:
    volatile enum PhoneType remotetarget;
    volatile enum Mode mode;
    volatile enum Status status;
    volatile int hook, packet_num, dataskip, timeout, dialconut, wait, timerled;
    EthernetNetIf *eth;
    UDPSocket *udpsock;
    Host remote;
    AnalogOut dac;
    AnalogIn adc;
    RingBuffer dial, dabuf, adbuf;
    struct ipline_header last;
    DigitalOut led_y, led_g;
    DigitalIn eth_link, eth_speed;

    void onLisnerEvent (UDPSocketEvent);
    void send (struct ipline_header *);
    void send (struct ipline_packet *);
    unsigned long xor128 ();
    int gaussian ();
};
