/** @file phone.h
 * @brief mbed Phone Platform
 */

#ifndef MAIN_H
#define MAIN_H

#define FREQ 8000
#define UDPPORT 20080
#define MTU 720
#define HOSTNAME_SIZE 30
#define DATA_SIZE 400
#define DIAL_SIZE 10
#define PB_SIZE 10
#define DIAL_TIMEOUT (FREQ * 3)
#define CALL_TIMEOUT (FREQ * 10)

/**
 * @brief Phone Type
 */
enum PhoneType {
    PhoneNone,
    PhoneLine1,
    PhoneLine2,
    PhoneMicSp,
    PhoneIpLine,
    PhoneType_FORCE_WORD = 0x7FFF
};

/**
 * @brief Status
 */
enum Status {
    StatusNone,
    StatusOk,
    StatusNg,
    Status_FORCE_WORD = 0x7FFF
};

/**
 * @brief Mode
 */
enum Mode {
    ModeOff,
    ModeReady,
    ModeDT,
    ModeDial,
    ModeCall,
    ModeRing,
    ModeRBT,
    ModeTalk,
    ModeBT,
    ModeDisconnect,
    ModeData,
    Mode_FORCE_WORD = 0x7FFF
};

/**
 * @brief Scan
 */
enum Scan {
    ScanMode,
    ScanStatus,
    ScanHook,
    ScanDial,
};
    
/**
 * @brief Tone
 */
enum Tone {
    DialTone,
    RingBackTone,
    BusyTone,
};

/**
 * @brief Phone Book
 */
struct PhoneBook {
    char dial[DIAL_SIZE];
    enum PhoneType target;
    char hostname[HOSTNAME_SIZE];
};

#define HookOff 0
#define HookOn 1

int config ();

#endif