#include "phone.h"
#include "mbed.h"
#include "RingBuffer.h"

/**
 * @brief Line class
 */
class Line {
public:
    Line (PinName p_line, PinName p_xline, PinName p_hook, AnalogOut p_dac);

    void intr ();
    void poll ();
    int enter (enum Mode);
    int scan (enum Scan);

private:
    volatile enum Mode mode;
    volatile enum Status status;
    volatile int dialtimer, dialcount, hooktimer, tonecount, hooktimer2;
    volatile int hook_last;
    DigitalOut line, xline;
    DigitalIn hook;
    AnalogOut dac;
    RingBuffer dial;

    void power (int);
    void ring ();
    void tone (enum Tone);
};
