#include "mbed.h"
#include "EthernetNetIf.h"
#include "ConfigFile.h"
#include "phone.h"

LocalFileSystem local("local");

extern EthernetNetIf *eth;
extern int useipline;
extern struct PhoneBook phonebook[];

char* chop (char *s) {
    int i;

    for (i = strlen(s) - 1; i >= 0; i --) {
        if (s[i] == ' ' || s[i] == '\n' || s[i] == '\r') {
            s[i] = 0;
        } else {
            break;
        }
    }
    return s;
}

int config () {
    int i, j;
    ConfigFile cfg;
    char buf[80], key[20];
    int ip0, ip1, ip2, ip3;
    EthernetErr r;
    IpAddr ipaddr, netmask, gateway, nameserver; 

    if (! cfg.read("/local/phone.cfg")) {
printf("config err\r\n");
        return -1;
    }

    if (cfg.getValue("IPADDRESS", buf, sizeof(buf))) {
        chop(buf);
        if (strcmp(buf, "DHCP") == 0) {
            eth = new EthernetNetIf;
        } else {
            sscanf(buf, "%d.%d.%d.%d", &ip0, &ip1, &ip2, &ip3);
            ipaddr = IpAddr(ip0, ip1, ip2, ip3);
            if (cfg.getValue("NETMASK", buf, sizeof(buf))) {
                sscanf(chop(buf), "%d.%d.%d.%d", &ip0, &ip1, &ip2, &ip3);
                netmask = IpAddr(ip0, ip1, ip2, ip3);
            }
            if (cfg.getValue("GATEWAY", buf, sizeof(buf))) {
                sscanf(chop(buf), "%d.%d.%d.%d", &ip0, &ip1, &ip2, &ip3);
                gateway = IpAddr(ip0, ip1, ip2, ip3);
            }
            if (cfg.getValue("NAMESERVER", buf, sizeof(buf))) {
                sscanf(chop(buf), "%d.%d.%d.%d", &ip0, &ip1, &ip2, &ip3);
                nameserver = IpAddr(ip0, ip1, ip2, ip3);
            }
            eth = new EthernetNetIf(ipaddr, netmask, gateway, nameserver);
        }
        r = eth->setup();
        if (! r) {
            useipline = 1;
        }
    }

    for (i = 0; i < PB_SIZE; i ++) {
        sprintf(key, "DIAL[%d]", i);
        if (cfg.getValue(key, buf, sizeof(buf))) {
            for (j = 0; j < strlen(buf) && j < DIAL_SIZE; j ++) {
                if (buf[j] == '0') {
                    phonebook[i].dial[j] = 10;
                } else
                if (buf[j] >= '1' && buf[j] <= '9') {
                    phonebook[i].dial[j] = buf[j] - '0';
                }
            }
            phonebook[i].dial[j] = 0;
        }
        sprintf(key, "TYPE[%d]", i);
        if (cfg.getValue(key, buf, sizeof(buf))) {
            phonebook[i].target = (enum PhoneType)atoi(buf);
        }
        sprintf(key, "ADDR[%d]", i);
        cfg.getValue(key, phonebook[i].hostname, sizeof(phonebook[i].hostname));
    }
    
    return 0;
}
    