/*
 * Memory File System Library, for SPI PRAM NP8P128A13 (Micron)
 * Copyright (c) 2012 Hiroshi Suga
 * Released under the MIT License: http://mbed.org/license/mit
 */

#ifndef _PRAMFileSystem_H_
#define _PRAMFileSystem_H_

#include "mbed.h"
#include "FATFileSystem.h"

#define CMD_WREN    0x06    // Write enable
#define CMD_WRDI    0x04    // Write disable
#define CMD_RDID    0x9f    // Read identification 
#define CMD_RDSR    0x05    // Read status register
#define CMD_WRSR    0x01    // Write status registe
#define CMD_READ    0x03    // Read data bytes
#define CMD_FREAD   0x0b    // Read data bytes at higher speed
#define CMD_PP      0x02    // Page program (legacy program)
#define CMD_PP_BA   0x22    // Page program (bit-alterable write)
#define CMD_PP_1S   0xd1    // Page program (On all 1s)
#define CMD_SE      0xd8    // Sector erase


class PRAMFileSystem : public FATFileSystem {
public:

    /** Create the File System for accessing an SD Card using SPI
     *
     * @param mosi SPI mosi pin connected to SD Card
     * @param miso SPI miso pin conencted to SD Card
     * @param sclk SPI sclk pin connected to SD Card
     * @param cs   DigitalOut pin used as SD Card chip select
     * @param name The name used to access the virtual filesystem
     */
    PRAMFileSystem (PinName mosi, PinName miso, PinName sclk, PinName cs, const char* name);
    virtual int disk_initialize ();
    virtual int disk_write (const char *buffer, int block_number);
    virtual int disk_read (char *buffer, int block_number);    
    virtual int disk_status ();
    virtual int disk_sync ();
    virtual int disk_sectors ();

protected:

    int _init ();
    int _status ();
    int _read (int addr, char *buf, int len);
    int _write (int addr, const char *buf, int len);
    int _sectors;
    
    SPI _spi;
    DigitalOut _cs; 
};

#endif
