
#define PID_REQUEST_ALL     0x7DF
#define PID_REQUEST         0x7E0
#define PID_REQUEST_ECU2    0x7E1
#define PID_REPLY           0x7E8
#define PID_REPLY_ECU2      0x7E9

/* Details from http://en.wikipedia.org/wiki/OBD-II_PIDs */
#define PID_0_20            0x00    //PID 0 - 20 supported
#define STATUS_DTC          0x01    ///
#define FREEZE_DTC          0x02    ///
#define FUEL_SYS_STATUS     0x03    ///
#define ENGINE_LOAD         0x04    //
#define ENGINE_COOLANT_TEMP 0x05
#define ST_FUEL_TRIM_1      0x06    ///
#define LT_FUEL_TRIM_1      0x07    ///
#define ST_FUEL_TRIM_2      0x08    ///
#define LT_FUEL_TRIM_2      0x09    ///
#define FUEL_PRESSURE       0x0A    //
#define INTAKE_PRESSURE     0x0B    //
#define ENGINE_RPM          0x0C
#define VEHICLE_SPEED       0x0D
#define TIMING_ADVANCE      0x0E    //
#define INTAKE_TEMP         0x0F    //
#define MAF_SENSOR          0x10
#define THROTTLE            0x11
#define COMMANDED_SEC_AIR   0x12    ///
#define O2_SENS_PRES        0x13    ///
#define O2_B1S1_VOLTAGE     0x14    ///
#define O2_B1S2_VOLTAGE     0x15    ///
#define O2_B1S3_VOLTAGE     0x16    ///
#define O2_B1S4_VOLTAGE     0x17    ///
#define O2_B2S1_VOLTAGE     0x18    ///
#define O2_B2S2_VOLTAGE     0x19    ///
#define O2_B2S3_VOLTAGE     0x1A    ///
#define O2_B2S4_VOLTAGE     0x1B    ///
#define OBDII_STANDARDS     0x1C    //List of OBDII Standars the car conforms to
#define O2_SENS_PRES_ALT    0x1D    ///
#define AUX_IN_STATUS       0x1E    ///
#define ENGINE_RUNTIME      0x1F    //
#define PID_21_40           0x20    //PID 21-40 supported
#define DIST_TRAVELED_MIL   0x21    ///
#define FUEL_RAIL_PRESSURE  0x22    //
#define FUEL_RAIL_PRES_ALT  0x23    ///
#define O2S1_WR_LAMBDA_V    0x24    ///
#define O2S2_WR_LAMBDA_V    0x25    ///
#define O2S3_WR_LAMBDA_V    0x26    ///
#define O2S4_WR_LAMBDA_V    0x27    ///
#define O2S5_WR_LAMBDA_V    0x28    ///
#define O2S6_WR_LAMBDA_V    0x29    ///
#define O2S7_WR_LAMBDA_V    0x2A    ///
#define O2S8_WR_LAMBDA_V    0x2B    ///
#define COMMANDED_EGR       0x2C    //
#define EGR_ERROR           0x2D    //
#define COMMANDED_EVAP_P    0x2E    ///
#define FUEL_LEVEL          0x2F    //
#define WARMUPS_SINCE_CLR   0x30    ///
#define DIST_SINCE_CLR      0x31    ///
#define EVAP_PRESSURE       0x32    //
#define BAROMETRIC_PRESSURE 0x33    //
#define O2S1_WR_LAMBDA_I    0x34    ///
#define O2S2_WR_LAMBDA_I    0x35    ///
#define O2S3_WR_LAMBDA_I    0x36    ///
#define O2S4_WR_LAMBDA_I    0x37    ///
#define O2S5_WR_LAMBDA_I    0x38    ///
#define O2S6_WR_LAMBDA_I    0x39    ///
#define O2S7_WR_LAMBDA_I    0x3A    ///
#define O2S8_WR_LAMBDA_I    0x3B    ///
#define CAT_TEMP_B1S1       0x3C    ///
#define CAT_TEMP_B1S2       0x3E    ///
#define CAT_TEMP_B2S1       0x3D    ///
#define CAT_TEMP_B2S2       0x3F    ///
#define PID_41_60           0x40    //PID 41-60 supported
#define MONITOR_STATUS      0x41    ///
#define ECU_VOLTAGE         0x42    //
#define ABSOLUTE_LOAD       0x43    //
#define COMMANDED_EQUIV_R   0x44    ///
#define REL_THROTTLE_POS    0x45    ///
#define AMB_AIR_TEMP        0x46    ///
#define ABS_THROTTLE_POS_B  0x47    ///
#define ABS_THROTTLE_POS_C  0x48    ///
#define ACCEL_POS_D         0x49    ///
#define ACCEL_POS_E         0x4A    ///
#define ACCEL_POS_F         0x4B    ///
#define COMMANDED_THROTTLE  0x4C    ///
#define TIME_RUN_WITH_MIL   0x4D    ///
#define TIME_SINCE_CLR      0x4E    ///
#define MAX_R_O2_VI_PRES    0x4F    ///
#define MAX_AIRFLOW_MAF     0x50    ///
#define FUEL_TYPE           0x51    //
#define ETHANOL_PERCENT     0x52    //
#define ABS_EVAP_SYS_PRES   0x53    ///
#define EVAP_SYS_PRES       0x54    ///
#define ST_O2_TRIM_B1B3     0x55    ///
#define LT_O2_TRIM_B1B3     0x56    ///
#define ST_02_TRIM_B2B4     0x57    ///
#define LT_O2_TRIM_B2B4     0x58    ///
#define ABS_FUEL_RAIL_PRES  0x59    ///
#define REL_ACCEL_POS       0x5A    ///
#define HYBRID_BATT_PCT     0x5B    ///
#define ENGINE_OIL_TEMP     0x5C    ///
#define FUEL_TIMING         0x5D    //
#define FUEL_RATE           0x5E    //
#define EMISSIONS_STANDARD  0x5F    ///
#define DEMANDED_TORQUE     0x61    ///
#define ACTUAL_TORQUE       0x62    ///
#define REFERENCE_TORQUE    0x63    //
#define ENGINE_PCT_TORQUE   0x64    ///
#define AUX_IO_SUPPORTED    0x65    ///
#define P_MAF_SENSOR        0x66    ///
#define P_ENGINE_COOLANT_T  0x67    ///
#define P_INTAKE_TEMP       0x68    ///
#define P_COMMANDED_EGR     0x69    ///
#define P_COMMANDED_INTAKE  0x6A    ///
#define P_EGR_TEMP          0x6B    ///
#define P_COMMANDED_THROT   0x6C    ///
#define P_FUEL_PRESSURE     0x6D    ///
#define P_FUEL_INJ_PRES     0x6E    ///
#define P_TURBO_PRESSURE    0x6F    ///
#define P_BOOST_PRES_CONT   0x70    ///
#define P_VGT_CONTROL       0x71    ///
#define P_WASTEGATE_CONT    0x72    ///
#define P_EXHAUST_PRESSURE  0x73    ///
#define P_TURBO_RPM         0x74    ///
#define P_TURBO_TEMP1       0x75    ///
#define P_TURBO_TEMP2       0x76    ///
#define P_CACT              0x77    ///
#define P_EGT_B1            0x78    ///
#define P_EGT_B2            0x79    ///
#define P_DPF1              0x7A    ///
#define P_DPF2              0x7B    ///
#define P_DPF_TEMP          0x7C    ///
#define P_NOX_NTE_STATUS    0x7D    ///
#define P_PM_NTE_STATUS     0x7E    ///
#define P_ENGINE_RUNTUME    0x7F    ///
#define P_ENGINE_AECD_1     0x81    ///
#define P_ENGINE_AECD_2     0x82    ///
#define P_NOX_SENSOR        0x83    ///
#define P_MANIFOLD_TEMP     0x84    ///
#define P_NOX_SYSTEM        0x85    ///
#define P_PM_SENSOR         0x86    ///
#define P_IN_MANIF_TEMP     0x87    ///


class OBD2 {
public:
    OBD2 (PinName rd, PinName td, int speed = 500000);
    int request (int pid);
    float read ();

private:
    CAN _can;
    int _pid;
    uint8_t _data[5];
    volatile int _received;

    void isrRecv ();
};
