#include "mbed.h"
#include "NECnfc.h"

DigitalOut led1(LED1), led2(LED2), led3(LED3), led4(LED4);
Serial pc(USBTX, USBRX);
NECnfc rf(p9, p10, p13, p14, p15, 38400, NECnfc::TYPE_920MHz); // tx, rx, reset, wakeup, mode
DigitalOut rts(p11);
Ticker timer;

void isr_recv () {
    char buf[NEC_MAXLENGTH + 1];
    int i, dest, src;
    i = rf.readData(&dest, &src, buf, sizeof(buf));
    if (i <= 0) return;
    buf[i] = 0;
    printf("recv to:%08x from:%08x '%s'\r\n", dest, src, buf);
    led4 = !led4;
}

int main() {
    Timer t;
    unsigned int id;

    rts = 0;
    led1 = 1;
    pc.baud(115200);
    pc.printf("*** NEC\r\n");
    wait(0.5);

    rf.attach(&isr_recv);
    rf.setRfConfig(NECnfc::PWR_MAX, 24, NECnfc::BAUD_50k);

    id = rf.getId();
    pc.printf(" id %08x\r\n", id);

    t.start();
    while(1) {
        rf.poll();

        if (pc.readable()) {
            char c = pc.getc();
            if (c == ' ') {
                led2 = 1;
                rf.send(NECnfc::NECMSG_SEND_NOACK, NEC_DUMMYID, "Hello mbed", 10);
            }
        }

        if (t.read() >= 5) {
            led3 = 1;
            t.reset();
            rf.send(NECnfc::NECMSG_SEND_NOACK, NEC_DUMMYID, "Hello World", 11);
        }

        led1 = !led1;
        led2 = 0;
        led3 = 0;
        wait(0.1);
    }
}
