#include "NECnfc.h"

void NECnfc::recvData (char c) {

#ifdef DEBUG_DUMP
    if (c < 0x20 || c >= 0x7f) {
        printf("%02x", c);
    } else {
        printf("_%c", c);
    }
#endif
    switch (_mode) {
    case MODE_READY:
        switch (_rxcount) {
        case 0:
            if (c == 0x0f) {
                _rxbuf[_rxcount] = c;
                _rxcount ++;
                _received = 0;
            }
            break;
        case 1:
            if (c == 0x5a) {
                _rxbuf[_rxcount] = c;
                _rxcount ++;
            } else {
                _rxcount = 0;
            }
            break;
        case 2:
            _rxbuf[_rxcount] = c;
            _rxcount ++;
            _rxlen = (int)((unsigned char)c);
            _mode = MODE_DATA;
            break;
        }
        break;
    case MODE_DATA:
        _rxbuf[_rxcount] = c;
        _rxcount ++;
        if (_rxcount >= _rxlen) {
            _rxcount = 0;
            _mode = MODE_READY;
            parseMessage();
        }
    }
}

void NECnfc::parseMessage () {
    DBG("parseMessage %02x\r\n", _rxmsg.msgid);

    _received = 0;
    if (_rxmsg.msgno != _msgno && _rxmsg.msgid != NECMSG_SEND_DAT && _rxmsg.msgid != NECMSG_SEND_NOACK) {
        DBG("error msgno %d %d\r\n", _rxmsg.msgno, _msgno);
        return;
    }

    switch (_rxmsg.msgid) {
    case NECMSG_ACK:
        _ack = 1;
        break;
    case NECMSG_NOACK:
        _noack = 1;
        break;
    case NECMSG_RESEND:
        _resend = 1;
        DBG("error resend %d %d\r\n", _rxmsg.parameter[0], _rxmsg.parameter[1]);
        break;
    case NECMSG_SEARCH:
        break;
    case NECMSG_SEND_DAT:
    case NECMSG_SEND_NOACK:
        _received = 1;
        break;
    }
    return;
}

int NECnfc::send (NECMSG msgid, unsigned int dest, const char *param, int len) {
    int i;
    struct ifMessage ifmsg;
    unsigned char *buf = (unsigned char *)&ifmsg;
    Timer t;

    if (_mode != MODE_READY) {
        t.start();
        while (_mode != MODE_READY) {
            poll();
            if (t.read() > NEC_TIMEOUT) {
                DBG("timeout\r\n");
                t.stop();
                return -1;
            }
        }
        t.stop();
        t.reset();
    }

    if (len > NEC_MAXLENGTH) len = NEC_MAXLENGTH;
    _msgno = (_msgno + 1) & 0xff;
    ifmsg.start = htons(0x0f5a);
    ifmsg.length = NEC_HEADER_SIZE + len;
    ifmsg.msgid = msgid;
    ifmsg.msgno = _msgno;
    ifmsg.dstid = htonl(dest);
    ifmsg.srcid = htonl(_id);
    memcpy(ifmsg.parameter, param, len);

    _ack = 0;
    _noack = 0;
    _resend = 0;
    for (i = 0; i < ifmsg.length; i ++) {
        _nec.putc(buf[i]);
    }

    t.start();
    for (;;) {
        if (_ack || _noack || _resend) break;
        if (t.read() > NEC_TIMEOUT) {
            DBG("timeout\r\n");
            t.stop();
            return -1;
        }
    }
    t.stop();
    DBG(" ack %d, noack %d, resend %d\r\n", _ack, _noack, _resend);
    return _ack ? 0 : -1;
}
