#include "NECnfc.h"

int NECnfc::setRfConfig (enum NECPWR power, int ch, NECBAUD baud) {
    char cmd[3];

    switch (_type) {
    case TYPE_2400MHz:
        if (ch < 0 || ch > 15) return -1;
        power = (enum NECPWR)(power >= PWR_HIGH ? 0x0f : 0x00);
    case TYPE_950MHz:
        if (power == PWR_LOW && (ch < 1 || ch > 33)) return -1;
        if (power >= PWR_MID && (ch < 17 || ch > 31)) return -1;
        break;
    case TYPE_920MHz:
        if (power <= PWR_MID && (ch < 24 || ch > 38)) return -1;
        if (power >= PWR_HIGH && (ch < 24 || ch > 37 || ch == 32)) return -1;
        break;
    }

    if (_type == TYPE_2400MHz) {
        cmd[0] = ch;
        if (send(NECMSG_WRITE_CHANNEL, NEC_DUMMYID, cmd, 1)) {
            return -1;
        }
        cmd[0] = power;
        if (send(NECMSG_WRITE_RFCONF, NEC_DUMMYID, cmd, 1)) {
            return -1;
        }
    } else {
        cmd[0] = power;
        cmd[1] = ch;
        cmd[2] = baud;
        if (send(NECMSG_WRITE_RFCONF, NEC_DUMMYID, cmd, 3)) {
            return -1;
        }
    }
    return 0;
}

unsigned int NECnfc::getId () {

    if (send(NECMSG_READ_DEFAULT, NEC_DUMMYID, NULL, 0)) {
        return 0;
    }
    if (_type == TYPE_2400MHz) {
        _id = (_rxmsg.parameter[23] << 24) | (_rxmsg.parameter[24] << 16) | (_rxmsg.parameter[25] << 8) | _rxmsg.parameter[26];
    } else {
        _id = (_rxmsg.parameter[21] << 24) | (_rxmsg.parameter[22] << 16) | (_rxmsg.parameter[23] << 8) | _rxmsg.parameter[24];
    }
    return _id;
}

unsigned int NECnfc::getSystemId () {
    unsigned int id;

    if (send(NECMSG_READ_DEFAULT, NEC_DUMMYID, NULL, 0)) {
        return 0;
    }

    if (_type == TYPE_2400MHz) {
        id = (_rxmsg.parameter[19] << 24) | (_rxmsg.parameter[20] << 16) | (_rxmsg.parameter[21] << 8) | _rxmsg.parameter[22];
    } else {
        id = (_rxmsg.parameter[17] << 24) | (_rxmsg.parameter[18] << 16) | (_rxmsg.parameter[19] << 8) | _rxmsg.parameter[20];
    }
    return id;
}

int NECnfc::setSystemId (unsigned int id) {
    int len;
    char buf[24];

    if (send(NECMSG_READ_DEFAULT, NEC_DUMMYID, NULL, 0)) {
        return 0;
    }

    if (_type == TYPE_2400MHz) {
        len = 23;
        memcpy(buf, _rxmsg.parameter, len);
        buf[19] = (id >> 24) & 0xff;
        buf[20] = (id >> 16) & 0xff;
        buf[21] = (id >> 8) & 0xff;
        buf[22] = id & 0xff;
    } else {
        len = 21;
        memcpy(buf, _rxmsg.parameter, len);
        buf[17] = (id >> 24) & 0xff;
        buf[18] = (id >> 16) & 0xff;
        buf[19] = (id >> 8) & 0xff;
        buf[20] = id & 0xff;
    }
    if (send(NECMSG_WRITE_DEFAULT, NEC_DUMMYID, buf, len)) {
        return -1;
    }
    return 0;
}

int NECnfc::setSleepMode (int sleep_time, int rev_time) {
    int len;
    char buf[24];

    if (send(NECMSG_READ_CONFIG, NEC_DUMMYID, NULL, 0)) {
        return 0;
    }

    if (_type == TYPE_2400MHz) {
        len = 22;
        memcpy(buf, _rxmsg.parameter, len);
        buf[12] = (rev_time >> 8) & 0xff;
        buf[13] = rev_time & 0xff;
        buf[14] = sleep_time;
    } else {
        len = 21;
        memcpy(buf, _rxmsg.parameter, len);
        buf[6] = sleep_time;
        buf[7] = (rev_time >> 8) & 0xff;
        buf[8] = rev_time & 0xff;
    }
    if (send(NECMSG_WRITE_CONFIG, NEC_DUMMYID, buf, len)) {
        return -1;
    }
    return 0;
}

int NECnfc::getRssi () {

    if (send(NECMSG_READ_RSSI, NEC_DUMMYID, NULL, 0)) {
        return 0;
    }
    return _rssi;
}

int NECnfc::search () {
    char cmd[1] = {1};
    Timer t;

    DBG("search\r\n");
    t.start();
    if (send(NECMSG_SEARCH, NEC_DUMMYID, cmd, 1)) {
        return -1;
    }
    for (;;) {
        if (_ack && _rxmsg.msgid == NECMSG_ACK) {
            DBG("found %08x", ntohl(_rxmsg.srcid));
            _ack = 0;
        }
        if (_resend) break;
        if (t.read() > NEC_TIMEOUT) {
            DBG("timeout\r\n");
            t.stop();
            return -1;
        }
    }
    t.stop();
    DBG(" ack %d, noack %d, resend %d\r\n", _ack, _noack, _resend);
    return 0;
}
