#include "NECnfc.h"

void NECnfc::setReset (bool flg) {
    if (_reset) {
        if (flg) {
            _reset->output();
            _reset->write(0);
        } else {
            _reset->input();
            _reset->mode(PullNone);
        }
    }
}

void NECnfc::isrUart () {
    recvData(getUart());
}

int NECnfc::getUart () {
    return _nec.getc();
}

void NECnfc::putUart (char c) {
    _nec.putc(c);
}

int NECnfc::lockUart (int ms) {
    return 0;
}

void NECnfc::unlockUart () {
}

void NECnfc::initUart (PinName reset, PinName wakeup, PinName mode, int baud) {
    if (baud) _nec.baud(baud);
    _nec.attach(this, &NECnfc::isrUart, Serial::RxIrq);

    _reset = NULL;
    if (reset != NC) {
        _reset = new DigitalInOut(reset);
    }
    _wakeup = NULL;
    if (wakeup != NC) {
        _wakeup = new DigitalOut(wakeup);
        _wakeup->write(0);
    }
    _wmode = NULL;
    if (mode != NC) {
        _wmode = new DigitalIn(mode);
        _wmode->mode(PullUp);
    }
}

int NECnfc::sleep (int wait) {

    if (!_wakeup) return -1;

    DBG("sleep\r\n");
    _wakeup->write(1);
    if (wait && _wmode) {
        while (! _wmode->read());
    }
    return 0;
}

int NECnfc::wakeup (int wait) {

    if (!_wakeup) return -1;

    DBG("wakeup\r\n");
    _wakeup->write(0);
    if (wait && _wmode) {
        while (_wmode->read());
    }
    return 0;
}
