/*
 * sample from http://mbed.org/forum/mbed/topic/234/?page=1#comment-1067
 */

#include "MyRPC.h"
#ifdef MBED_RPC
#include "rpc.h"
#endif

namespace mbed {

MyRPC::MyRPC(PinName pin, const char *name) : Base(name), _pin(pin) {}

void MyRPC::blink(int n) {
    for (int i=0; i<n; i++) {
        _pin = 1;
        wait(0.2);
        _pin = 0;
        wait(0.2);
    }
}

int MyRPC::number() {
    return rand();
}

#ifdef MBED_RPC
const rpc_method *MyRPC::get_rpc_methods() {
  static const rpc_method rpc_methods[] = {
    { "blink", rpc_method_caller<MyRPC, int, &MyRPC::blink>},
    { "number", rpc_method_caller<int, MyRPC, &MyRPC::number> },
    RPC_METHOD_SUPER(Base)
  };
  return rpc_methods;
}       

rpc_class *MyRPC::get_rpc_class() {
    static const rpc_function funcs[] = {
        "new", rpc_function_caller<const char*, PinName, const char*, &Base::construct<MyRPC,PinName,const char*> >,
        RPC_METHOD_END
    };
    static rpc_class c = { "MyRPC", funcs, NULL };
    return &c;
}
#endif

}    // namespace mbed

