#include "mbed.h"

DigitalOut led1(LED1), led2(LED2), led3(LED3), led4(LED4);

DigitalOut m1a(p29), m1b(p30), m2a(p27), m2b(p28);
PwmOut m1p(p26), m2p(p25);

void motor (int num, float speed, int brake) {
    if (num == 1) {
        if (brake) {
            m1p = 1;
            m1a = 1;
            m1b = 1;
        } else
        if (speed > 0) {
            m1p = speed;
            m1a = 1;
            m1b = 0;
        } else
        if (speed < 0) {
            m1p = - speed;
            m1a = 0;
            m1b = 1;
        } else {
            m1p = 1;
            m1a = 0;
            m1b = 0;
        }
    } else
    if (num == 2) {
        if (brake) {
            m2p = 1;
            m2a = 1;
            m2b = 1;
        } else
        if (speed > 0) {
            m2p = speed;
            m2a = 1;
            m2b = 0;
        } else
        if (speed < 0) {
            m2p = - speed;
            m2a = 0;
            m2b = 1;
        } else {
            m2p = 1;
            m2a = 0;
            m2b = 0;
        }
    }
}

void stepper (int n) {
    switch (n) {
    case 0:
        motor(1, 1, 0);
        motor(2, 0, 0);
        led1 = 1;
        break;
    case 1:
        motor(1, 1, 0);
        motor(2, 1, 0);
        led1 = 0;
        break;
    case 2:
        motor(1, 0, 0);
        motor(2, 1, 0);
        led2 = 1;
        break;
    case 3:
        motor(1, -1, 0);
        motor(2, 1, 0);
        led2 = 0;
        break;
    case 4:
        motor(1, -1, 0);
        motor(2, 0, 0);
        led3 = 1;
        break;
    case 5:
        motor(1, -1, 0);
        motor(2, -1, 0);
        led3 = 0;
        break;
    case 6:
        motor(1, 0, 0);
        motor(2, -1, 0);
        led4 = 1;
        break;
    case 7:
        motor(1, 1, 0);
        motor(2, -1, 0);
        led4 = 0;
        break;
    }
}

int main() {
    int i;

    while(1) {
        for (i = 0; i < 8; i ++) {
            stepper(i);
            wait(0.002);
        }
    }
}
