#include "mbed.h"
#include "MelInverter.h"

DigitalOut myled(LED1);
Serial pc(USBTX, USBRX);

MelInverter mel(p28, p27);

int main() {
    int i;
    char c;
    char buf[20];

    pc.baud(115200);

    pc.printf("MelInverter\r\n");

    myled = 1;
    for (;;) {
        if (pc.readable()) {
            c = pc.getc();
            pc.putc(c);
            switch (c) {
            case 'r':
                // cw
                mel.send(0, MELCMD_RUN, "02");
                break;
            case 'c':
                // ccw
                mel.send(0, MELCMD_RUN, "04");
                break;
            case 's':
                // stop
                mel.send(0, MELCMD_RUN, "00");
                break;
            case '0':
            case '1':
            case '2':
            case '3':
            case '4':
            case '5':
            case '6':
                // freq x10Hz
                sprintf(buf, "%04X", (c - '0') * 1000);
                mel.send(0, MELCMD_FREQ, buf);
                break;
            case '?':
                // name
                mel.send(0, MELCMD_NAME_R, "");
                i = mel.recv(0, buf, sizeof(buf) - 1);
                buf[i] = 0;
                pc.printf("recv: %s\r\n", buf);
                break;
            }
        }
    }

}
