/**
 * Mitsubishi Inverter Protocol library for mbed
 * Copyright (c) 2012 Suga
 * Released under the MIT License: http://mbed.org/license/mit
 */

/** @file
 * @brief Mitsubishi Inverter Protocol library for mbed
 * @note need: http://mbed.org/users/okini3939/libraries/RingBuffer/latest
 *  FR-E700
 *  Pr.79=2, Pr.340=1, Pr.549=0
 *  19200bps, 8bit data, Stop 2bit, Even parity, CR
 */

#include "mbed.h"
#include "RingBuffer.h"

#define MELDELAY 0
#define MELTIMEOUT 100
#define MELBAUD 19200

enum MELCMD {
    MELCMD_MODE_R = 0x7b,
    MELCMD_FREQ_R = 0x6f,
    MELCMD_CURRENT_R = 0x70,
    MELCMD_VOLT_R = 0x71,
    MELCMD_MONITOR_R = 0x73,
    MELCMD_STATUS = 0x79,
    MELCMD_RUN = 0xfa,
    MELCMD_FREQ = 0xed,
    MELCMD_FREQ_ROM = 0xee,
    MELCMD_RESET = 0xfd,
    MELCMD_ALLCLEAR = 0xfc,
    MELCMD_NAME_R = 0x7c,
    MELCMD_CAPA_R = 0x7d,
};

enum MELMODE {
    MELMODE_NONE,
    MELMODE_STX,
    MELMODE_ACK,
    MELMODE_NAK,
};

enum INVCTRL {
    INVCTRL_STX = 0x02,
    INVCTRL_ETX = 0x03,
    INVCTRL_ENQ = 0x05,
    INVCTRL_ACK = 0x06,
    INVCTRL_LF = 0x0a,
    INVCTRL_CR = 0x0d,
    INVCTRL_NAK = 0x15,
};

/**
 * MelInverter class
 */
class MelInverter {
public:
    /**
     * Default constructor
     */
    MelInverter (PinName p_tx, PinName p_rx, int baud = MELBAUD);

    int send (int iid, MELCMD, char *data);

    int recv (int iid, char *buf, int len);

protected:
    int x2i (char c);
    char i2x (int i);
    void isr_mel ();
    void isr_ack ();
    void isr_nak ();

private:
    Serial _mel;
    volatile int _mel_ok, _mel_failure, _mel_recv;
    MELMODE _mel_mode;
    RingBuffer _buf_data;
    Timeout _res;
    volatile int _iid;

};

