#include "mbed.h"
#include "USBMIDI.h"
#include "MIDI.h"

DigitalOut led1(LED1), led2(LED2), led3(LED3), led4(LED4);
Serial pc(USBTX, USBRX);

USBMIDI usbmidi;
MIDI midi(p9, p10);

void show_message(MIDIMessage msg) {
    switch (msg.type()) {
    case MIDIMessage::NoteOffType:
        midi.sendNoteOff(msg.key(), msg.pitch(), msg.channel());
        break;
    case MIDIMessage::NoteOnType:
        midi.sendNoteOn(msg.key(), msg.pitch(), msg.channel());
        break;
    case MIDIMessage::PolyphonicAftertouchType:
        midi.sendPolyPressure(msg.key(), msg.pressure(), msg.channel());
        break;
    case MIDIMessage::ControlChangeType:
        midi.sendControlChange(msg.controller(), msg.value(), msg.channel());
        break;
    case MIDIMessage::ProgramChangeType:
        midi.sendProgramChange(msg.program(), msg.channel());
        break;
    case MIDIMessage::ChannelAftertouchType:
        midi.sendAfterTouch(msg.pressure(), msg.channel());
        break;
    case MIDIMessage::PitchWheelType:
        midi.sendPitchBend(msg.pitch(), msg.channel());
        break;
    case MIDIMessage::AllNotesOffType:
        midi.sendControlChange(123, 0, msg.channel());
        break;
    case MIDIMessage::ErrorType:
    default:
        led4 = 1;
        break;
    }
    led3 = 1;
}

void isr_t () {
    led2 = 0;
    led3 = 0;
    led4 = 0;
}

int main() {
    Ticker t;

    led1 = 1;
    usbmidi.attach(show_message);
    midi.begin();   
    t.attach(isr_t, 0.1);

    for (;;) {
        if (midi.read()) {
            MIDIMessage msg;
            msg.data[0] = CABLE_NUM | (midi.getType() >> 4);
            msg.data[1] = midi.getType() | midi.getChannel();
            msg.data[2] = midi.getData1();
            msg.data[3] = midi.getData2();
            usbmidi.write(msg);
            led2 = 1;
        }
    }
}
