#include "mbed.h"
#include "LTC_SMPTE.h"

DigitalOut led1(LED1), led2(LED2);
Serial pc(USBTX, USBRX);

LTC_SMPTE ltc(p21, LTC_SMPTE::LTC_INPUT); // input
//LTC_SMPTE ltc(p22, LTC_SMPTE::LTC_OUTPUT); // output

int main() {
    pc.baud(115200);
    pc.printf("*** LTC\r\n");
    led1 = 1;
    led2 = 0;

    // input
    while(1) {
        if (ltc.isReceived()) {
            int hour, min, sec, frame;
            ltc.read(&hour, &min, &sec, &frame);
            pc.printf("%d %d %d %d\r\n", hour, min, sec, frame);
            led2 = !led2;
        }
    }
/*
    // output
    ltc.write(0, 0, 0, 0);
    while (1) {
        int hour, min, sec, frame;
        ltc.read(&hour, &min, &sec, &frame);
        pc.printf("%d %d %d %d\r\n", hour, min, sec, frame);
        led2 = !led2;
        wait(1);
    }
*/
}
