/**
 * SMPTE timedode (LTC) decode library for mbed
 * Copyright (c) 2015 Suga
 * Released under the MIT License: http://mbed.org/license/mit
 */
/** @file
 * @brief SMPTE timedode (LTC) decode library for mbed
 */

#ifndef _LTC_SMPTE_H_
#define _LTC_SMPTE_H_

#include "mbed.h"

class LTC_SMPTE {
public:
    enum LTC_TYPE {
        LTC_INPUT,
        LTC_OUTPUT
    };

    LTC_SMPTE (PinName pin, enum LTC_TYPE type = LTC_INPUT);

    void read (int *hour, int *min, int *sec, int *frame, int *dir = NULL);
    int isReceived ();

    void write (int hour, int min, int sec, int frame, int dir = 0);

    static LTC_SMPTE *_inst;
    void isr_ticker ();

protected:
    InterruptIn *_input;
    Timer _timer;
    DigitalOut *_output;

    int mode;
    int oneflg;
    int count;
    int bit;
    char code[10];
    int hour, min, sec, frame;
    int drop, direction, fps;
    int received;

    enum LTC_TYPE type;
    int phase, zeroflg;

    void isr_change ();
    void parse_code ();

};

#endif
