/*
 * WS2812 tape led IC
 */
#include "mbed.h"
#include "LEDStrip.h"

Serial pc(USBTX, USBRX);
DigitalOut led1(LED1), led2(LED2), led3(LED3), led4(LED4);

extern "C"
void HardFault_Handler() {
    printf("Hard Fault!\r\n");
    exit(-1);
}

int main() {
    int i, j, k = 0;

    pc.baud(115200);
    tapeInit(0, 16);
    led1 = 1;

    pc.printf("led\r\n");

    for (;;) {
        for (i = 0; i < 256; i ++) {
            led2 = 1;
            tapeSet(0, (i << 16));
            tapeSet(2, (i << 8));
            tapeSet(4, i);
            tapeSet(6, (i << 8)|i);
            tapeSet(7, (i << 16)|i);
            tapeSet(8, (i << 16)|(i << 8));
            tapeSet(9, (i << 16)|(i << 8)|i);
            tapeSend();
            led2 = 0;
            wait_ms(20);
        }
        for (i = 0; i < 160; i ++) {
            tapeSet(i, 0);
        }
        tapeSend();
    }
}
