/*
 * UCS1903 tape led IC
 */
#include "mbed.h"
#include "LEDTape.h"

DigitalOut led1(LED1), led2(LED2), led3(LED3), led4(LED4);

int main() {
    int i, j, k = 0;

    tapeInit(0);
    led1 = 1;

    tapeReset(1);
    wait(0.1);
    while(1) {
        for (i = 0; i < 256; i ++) {
            led2 = 1;
            tapeReset(0);
            for (j = 0; j < k; j ++) {
                tapeSend(0);
            }
            tapeSend(i); // G
            tapeSend(0);
            tapeSend(i << 8); // B
            tapeSend(0);
            tapeSend(i << 16); // R
            tapeSend(0);
            tapeSend(i | (i << 8) | (i << 16));
            tapeSend(0);
            tapeReset(1);
            led2 = 0;
            k ++;
            if (k >= 100) k = 0;
            wait_ms(10);
        }
    }
}
