/*
 * UCS1903 tape led IC
 */
#include "mbed.h"
#include "LEDTape.h"

SPI tape(p11, p12, p13);

//#define tape_write(d) tape.write(d)
#ifndef tape_write
#if defined(TARGET_LPC1768) || defined(TARGET_LPC2368)
void tape_write (int d) {
    while (! (LPC_SSP0->SR & (1<<1))); // TNF
    LPC_SSP0->DR = d;
}
#elif defined(TARGET_LPC11U24)
void tape_write (int d) {
    while (! (LPC_SSP1->SR & (1<<1))); // TNF
    LPC_SSP1->DR = d;
}
#endif
#endif

void tapeReset (int flag) {
    int i;

    __disable_irq();
#if defined(TARGET_LPC1768) || defined(TARGET_LPC2368)
    if (flag) {
        while ((LPC_SSP0->SR & ((1<<4)|(1<<0))) != (1<<0)); // BSY, TFE
        LPC_PINCON->PINSEL1 &= ~(0x03<<4);  // GPIO
        LPC_GPIO0->FIODIR0 |= (1<<18);
        LPC_GPIO0->FIOSET0 = (1<<18);
    } else {
        for (i = 0; i < 4; i ++) {
            tape_write(0x1f);
        }
        LPC_PINCON->PINSEL1 &= ~(0x03<<4);
        LPC_PINCON->PINSEL1 |= (0x02<<4);  // SSP MOSI
    }
#elif defined(TARGET_LPC11U24)
    if (flag) {
        while ((LPC_SSP1->SR & ((1<<4)|(1<<0))) != (1<<0)); // BSY, TFE
        LPC_IOCON->PIO1_22 &= ~0x07;    // GPIO
        LPC_GPIO->DIR[1] |= (1<<22);
        LPC_GPIO->SET[1] |= (1<<22);
    } else {
        for (i = 0; i < 4; i ++) {
            tape_write(0x1f);
        }
        LPC_IOCON->PIO1_22 &= ~0x07;    
        LPC_IOCON->PIO1_22 |= 0x02;     // SSP MOSI
    }
#endif
    __enable_irq();
}

void tapeSend (int dat) {
    int b;

    __disable_irq();
    for (b = 0x800000; b; b = b >> 1) {
        if (dat & b) {
            // 1
            tape_write(0x01);
        } else {
            // 0
            tape_write(0x0f);
        }
    }
    __enable_irq();
}

void tapeInit (int freq) {
    tape.format(5, 1);
    if (freq) {
        tape.frequency(freq * 1000);
    } else {
        // high speed (800kbps)
        tape.frequency(4000000);
    }
    tapeReset(1);
}
