/*
 * HL1606 tape led IC
 */
#include "mbed.h"
#include "LEDTape.h"

#define PWM_STEP 64

SPI tape(p11, p12, p13);
DigitalOut latch(p14);

#if defined(TARGET_LPC1768) || defined(TARGET_LPC2368)
    LPC_SSP_TypeDef *_ssp = LPC_SSP0;
#elif defined(TARGET_LPC11U24)
    LPC_SSPx_Type *_ssp = LPC_SSP1;
#endif

int num = 160;
int *data;


//#define tape_write(d) tape.write(d)
#ifndef tape_write
void tape_write (int d) {
    while (! (_ssp->SR & (1<<1))); // TNF
    _ssp->DR = d;
}
#endif

extern "C"
#if defined(TARGET_LPC1768) || defined(TARGET_LPC2368)
void SSP0_IRQHandler() {
#elif defined(TARGET_LPC11U24)
void SSP1_IRQHandler() {
#endif
    static int addr = num - 1;
    static int pwm = 0;
    int d, dr, r, g, b;
repeat:
    // led data
    while (_ssp->SR & (1<<1)) { // TNF
        d = data[addr];
        r = (d >> 16) & 0xff;
        g = (d >> 8) & 0xff;
        b = d & 0xff;

        dr = 0x80;
#ifdef PWM_STEP
        if (r > pwm || r == 0xff) {
            dr |= 0x04;
        }
        if (g > pwm || g == 0xff) {
            dr |= 0x10;
        }
        if (b > pwm || b == 0xff) {
            dr |= 0x01;
        }
#else
        if (r) {
            dr |= 0x04;
        }
        if (g) {
            dr |= 0x10;
        }
        if (b) {
            dr |= 0x01;
        }
#endif
        _ssp->DR = dr;

        addr --;
        if (addr < 0) {
            addr = num - 1;
#ifdef PWM_STEP
            pwm += PWM_STEP;
            if (pwm > 255) {
                pwm = 0;
            }
#endif
            while ((_ssp->SR & ((1<<4)|(1<<0))) != (1<<0)); // BSY, TFE
            latch = 1;
            wait_us(10);
            latch = 0;
            goto repeat;
        }
    }
}

void tapeInit (int freq, int n) {

    num = n;
    data = new int(num);
    for (int i = 0; i < num; i ++) {
        data[i] = 0;
    }

    tape.format(8, 0);
    latch = 0;
    if (freq) {
        tape.frequency(freq * 1000);
    } else {
        // 450KHz, higher speed = draw errors
        tape.frequency(450000);
    }
#if defined(TARGET_LPC1768) || defined(TARGET_LPC2368)
    NVIC_SetVector(SSP0_IRQn, (uint32_t)SSP0_IRQHandler);
    NVIC_SetPriority(SSP0_IRQn, 0);
    NVIC_EnableIRQ(SSP0_IRQn);
#elif defined(TARGET_LPC11U24)
    NVIC_SetVector(SSP1_IRQn, (uint32_t)SSP1_IRQHandler);
    NVIC_SetPriority(SSP1_IRQn, 0);
    NVIC_EnableIRQ(SSP1_IRQn);
#endif
    _ssp->IMSC |= (1<<3); // TXIM
}

void tapeSet (int n, int dat) {
    if (n < num) {
        data[n] = dat;
    }
}

void tapeSend () {
}
