/*
 * mbed library for K.I.T.T. Scanner
 * Copyright (c) 2010 Hiroshi Suga
 * Released under the MIT License: http://mbed.org/license/mit
 */
 
#include "mbed.h"
#include "KITTScanner.h"

KITTScanner::KITTScanner () {
    led[0] = new PwmOut(LED1);
    led[1] = new PwmOut(LED2);
    led[2] = new PwmOut(LED3);
    led[3] = new PwmOut(LED4);
    newflg = 1;
}

KITTScanner::KITTScanner (PwmOut &led1, PwmOut &led2, PwmOut &led3, PwmOut &led4) {
    led[0] = &led1;
    led[1] = &led2;
    led[2] = &led3;
    led[3] = &led4;
    newflg = 0;
}

KITTScanner::~KITTScanner () {
    int i;

    stop(1);
    if (newflg) {
        for (i = 0; i < 4; i ++) {
            delete led[i];
        }
    }
}

void KITTScanner::start (float speed) {
    int i;

    for (i = 0; i < 4; i ++) {
        bright[i] = 0;
    }
    num = 0;
    quit = 0;
    ticker.attach(this, &KITTScanner::int_KITTScanner, speed / 6.0);
}

void KITTScanner::stop (int flg) {
    int i;

    if (flg) {
        // fast stop
        ticker.detach();
        for (i = 0; i < 4; i ++) {
            *led[i] = 0;
        }
    } else {
        // slow stop
        quit = 1;
    }
}

void KITTScanner::int_KITTScanner () {
    int i, flg;

    for (i = 0; i < 4; i ++) {
        *led[i] = bright[i];

        // fade out
        bright[i] = bright[i] / 3.0;
        if (bright[i] < (1.0 / 3.0 / 3.0)) {
            bright[i] = 0;
        }
    }

    if (! quit) {
        // scan

        if (num >= 0) {
            // right
            bright[num] = 1.0;
            num ++;
            if (num > 3) {
                num = -2;
            }
        } else {
            // left
            bright[- num] = 1.0;
            num ++;
        }

    } else {
        // slow stop

        flg = 0;
        for (i = 0; i < 4; i ++) {
            if (bright[i] > 0) {
                flg = 1;
                break;
            }
        }
        if (! flg) {
            // all led off
            ticker.detach();
            for (i = 0; i < 4; i ++) {
                *led[i] = 0;
            }
        }

    }
}
