#include "mbed.h"
#include "IM920.h"

DigitalOut myled(LED1);
Serial pc(USBTX, USBRX);
IM920 im920(p28, p27, p29, p30);

void callback () {
    int i;
    char buf[65];

    i = im920.recv(buf, 64);
    buf[i] = 0;
    printf("recv: '%s' (%d)\r\n", buf, i);
}

int main() {
    int i = 0;
    char buf[65];

    pc.baud(115200);
    pc.printf("*** IM920\r\n");
    im920.init();
    im920.attach(callback);
    myled = 1;

    for (;;) {
        im920.poll();
        if (pc.readable()) {
            char c = pc.getc();
            if (c == '\r') {
                buf[i] = 0;
                printf("send: %s\r\n", buf);
                im920.send(buf, i);
                i = 0;
            } else
            if (i < 64) {
                buf[i] = c;
                i ++;
            }
        }
    }
}

